using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    struct Mast
    {
        public long x, h;
    }

    static long Dist(long x1, long y1, long x2, long y2)
    {
        long dx = x1 - x2;
        long dy = y1 - y2;
        return (long)Math.Sqrt(dx * dx + dy * dy);
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var xs = Console.ReadLine().Split().Select(long.Parse).ToArray();
        var hs = Console.ReadLine().Split().Select(long.Parse).ToArray();

        Mast[] a = new Mast[n];
        for (int i = 0; i < n; i++)
            a[i] = new Mast { x = xs[i], h = hs[i] };

        Array.Sort(a, (p, q) => p.x.CompareTo(q.x));

        long[] ans = Enumerable.Repeat(long.MaxValue, n).ToArray();

        Stack<int> st = new Stack<int>();
        for (int i = 0; i < n; i++)
        {
            while (st.Count > 0)
            {
                int j = st.Peek();
                long dx = a[i].x - a[j].x;
                if (a[j].h - dx >= a[i].h)
                {
                    ans[i] = Math.Min(ans[i], dx);
                    break;
                }
                if (a[j].h <= a[i].h) st.Pop();
                else break;
            }
            st.Push(i);
        }

        st.Clear();
        for (int i = n - 1; i >= 0; i--)
        {
            while (st.Count > 0)
            {
                int j = st.Peek();
                long dx = a[j].x - a[i].x;
                if (a[j].h - dx >= a[i].h)
                {
                    ans[i] = Math.Min(ans[i], dx);
                    break;
                }
                if (a[j].h <= a[i].h) st.Pop();
                else break;
            }
            st.Push(i);
        }

        for (int i = 0; i < n; i++)
        {
            if (ans[i] == long.MaxValue)
                Console.WriteLine(-1);
            else
                Console.WriteLine(ans[i]);
        }
    }
}